var font = LoadFont("Font.rfn");

var scrollUp = LoadImage("Scroll Up.png");
var scrollDown = LoadSurface("Scroll Down.png");
var scrollLeft = LoadSurface("Scroll Left.png");
var scrollRight = LoadSurface("Scroll Right.png");
var mapIcon = LoadImage("Map Icon.png");
var tileIcon = LoadImage("Tile Layer.png");
var objectIcon = LoadImage("Object Layer.png");
var entityIcon = LoadImage("Entity Layer.png");
var background = LoadSurface("Background.png");
var player = LoadImage("Player.png");
var layerVisible = LoadImage("Layer Visible.png");
var layerInvisible = LoadImage("Layer Invisible.png");

//========================================================================================================================
//
//                                                     Other Functions
//
//========================================================================================================================

//========================================================================================================================
//                                                     Get Tile
//========================================================================================================================

function getTile(x, y, w, h)
{
  var point = new Object;
  point.x = Math.floor(x / w);
  point.y = Math.floor(y / h);
  return point
}

//========================================================================================================================
//                                                     Draw Tile Selecter
//========================================================================================================================

function drawTileSelect(x, y, w, h, color)
{
  this.color = color || CreateColor(255, 255, 255, 255);
  OutlinedRectangle(x, y, w, h, CreateColor(0, 0, 0, 255), 5);
  OutlinedRectangle(x + 1, y + 1, w - 2, h - 2, this.color, 3);
}

//========================================================================================================================
//                                                     Create Window
//========================================================================================================================

function createWindow(w, h, xOffset, yOffset)
{
  var window = CreateSurface(w + 4 + xOffset, h + 4 + yOffset, CreateColor(0, 0, 0, 0));

  var testX = (window.width - 4) / background.width;
  var testY = (window.height - 4) / background.height;
  
  for (var x = 0; x < testX; x++)
  {
    for (var y = 0; y < testY; y++)
    {
      window.blitSurface(background, 2 + (x * background.width), 2 + (y * background.height));
    }
  }

  window.line(w + 3 + xOffset, 0, w + 3 + xOffset, h + 3 + yOffset, black);
  window.line(0, h + 3 + yOffset, w + 3 + xOffset, h + 3 + yOffset, black);
  
  window.line(1, 1, w + 2 + xOffset, 1, white);
  window.line(1, 1, 1, h + 1 + yOffset, white);
  
  window.line(1, h + 2 + yOffset, w + 2 + xOffset, h + 2 + yOffset, windowGrey2);
  window.line(w + 2 + xOffset, 2, w + 2 + xOffset, h + 2 + yOffset, windowGrey2);
  
  window.line(0, 0, w + 2 + xOffset, 0, windowGrey1);
  window.line(0, 0, 0, h + 2 + yOffset, windowGrey1);
  
  return window.createImage();
}

//========================================================================================================================
//                                                     Draw Text
//========================================================================================================================

function drawText(x, y, text)
{
  font.setColorMask(black);
  font.drawText(x + 1, y + 1, text);
  font.setColorMask(white);
  font.drawText(x, y, text);
}

//========================================================================================================================
//                                                     Switch Resolution
//========================================================================================================================

function switchResolution(width, height) {
    var proj = OpenFile("../game.sgm");
    proj.write("screen_height", height);
    proj.write("screen_width", width);
    proj.close();
    RestartGame();
}

//========================================================================================================================
//                                                     Horizontal Scrollbars
//========================================================================================================================

//========================================================================================================================
//                                                     Object
//========================================================================================================================

function _horizontalScrollbar(x, y, w, h, parent)
{
  this.x = x;
  this.y = y + h;
  this.w = w;
  this.h = h;
  this.parent = parent;

  this.create = function()
  {
    this.middle = CreateSurface(Math.ceil((w - 32) / ((parent.xMax+1))), 16, CreateColor(195, 195, 195, 255));
    this.middle.line(this.middle.width - 1, 0, this.middle.width - 1, this.middle.height - 1, CreateColor(0, 0, 0, 255));
    this.middle.line(0, this.middle.height - 1, this.middle.width - 1, this.middle.height - 1, CreateColor(0, 0, 0, 255));
  
    this.middle.line(1, 1, this.middle.width - 2, 1, CreateColor(255, 255, 255, 255));
    this.middle.line(1, 1, 1, this.middle.height - 2, CreateColor(255, 255, 255, 255));
  
    this.middle.line(this.middle.width - 2, 1, this.middle.width - 2, this.middle.height - 2, CreateColor(122, 132, 131, 255));
    this.middle.line(2, this.middle.height - 2, this.middle.width - 2, this.middle.height - 2, CreateColor(122, 132, 131, 255));
  
    this.middle.createImage();
  
    this.space = (this.w - 32 - this.middle.width) / (this.parent.xMax);
    if (this.parent.xMax == 0) this.space = 0;
  }
  this.create();
}

//========================================================================================================================
//                                                     Update
//========================================================================================================================

_horizontalScrollbar.prototype.update = function()
{
  if (mouse.isMouseOver(this.x, this.y, 16, 16))
  {
    this.parent.scrollLeft();
    mouse.clearQueue();
  }
  if (mouse.isMouseOver(this.x + this.w - 16, this.y, 16, 16))
  {
    this.parent.scrollRight();
    mouse.clearQueue();
  }
}

//========================================================================================================================
//                                                     Render
//========================================================================================================================

_horizontalScrollbar.prototype.render = function()
{
  scrollLeft.blit(this.x, this.y);
  scrollRight.blit(this.x + this.w - 16, this.y);
  Rectangle(this.x + 16, this.y, this.w - 32, 16, CreateColor(150,150,150,255));
  this.middle.blit(this.x + 16 + (this.parent.xScroll * this.space), this.y);
}

//========================================================================================================================
//                                                     Vertical Scrollbars
//========================================================================================================================

//========================================================================================================================
//                                                     Object
//========================================================================================================================

function _verticalScrollbar(x, y, w, h, parent)
{  
  this.x = x + w;
  this.y = y;
  this.w = w;
  this.h = h;
  this.parent = parent;
  
  this.create = function()
  {
    this.middle = CreateSurface(16, Math.ceil((this.h - 32) / (this.parent.yMax+1)), CreateColor(195, 195, 195, 255));
    this.middle.line(this.middle.width - 1, 0, this.middle.width - 1, this.middle.height - 1, CreateColor(0, 0, 0, 255));
    this.middle.line(0, this.middle.height - 1, this.middle.width - 1, this.middle.height - 1, CreateColor(0, 0, 0, 255));
  
    this.middle.line(1, 1, this.middle.width - 2, 1, CreateColor(255, 255, 255, 255));
    this.middle.line(1, 1, 1, this.middle.height - 2, CreateColor(255, 255, 255, 255));
      
    this.middle.line(this.middle.width - 2, 1, this.middle.width - 2, this.middle.height - 2, CreateColor(122, 132, 131, 255));
    this.middle.line(2, this.middle.height - 2, this.middle.width - 2, this.middle.height - 2, CreateColor(122, 132, 131, 255));
  
    this.middle.createImage();
    this.space = (this.h - 32 - this.middle.height) / (this.parent.yMax);
    if (this.parent.yMax === 0) this.space = 0;
  }
  this.create();
}

//========================================================================================================================
//                                                     Update
//========================================================================================================================

_verticalScrollbar.prototype.update = function()
{
  if (mouse.isMouseOver(this.x, this.y, 16, 16))
  {
    this.parent.scrollUp();
    mouse.clearQueue();
  }
  if (mouse.isMouseOver(this.x, this.y + this.h - 16, 16, 16))
  {
    this.parent.scrollDown();
    mouse.clearQueue();
  }
}

//========================================================================================================================
//                                                     Render
//========================================================================================================================

_verticalScrollbar.prototype.render = function()
{
  scrollUp.blit(this.x, this.y);
  scrollDown.blit(this.x, this.y + this.h - 16);
  Rectangle(this.x, this.y + 16, 16, this.h - 32, CreateColor(150,150,150,255));
  this.middle.blit(this.x, this.y + 16 + (this.space * this.parent.yScroll));
}

//========================================================================================================================
//                                                     Drop Box
//========================================================================================================================

//========================================================================================================================
//                                                     Object
//========================================================================================================================

function _dropBox(x, y, w, parent, array)
{
  this.parent = parent;
  this.x = x;
  this.y = y;
  this.w = w;
  this.list = array;
  this.selection = 0;
  this.openDrop = true;
  this.yScroll = 0;
  this.vMax = 13;
  this.yMax = array.length - this.vMax;
  if (this.yMax < 0) this.yMax = 0;
  
  this.window = createWindow(w, 208, 0, 0);
  
  this.image = createWindow(w, 20, 0, 0).createSurface();

  this.image.line(2, 2, this.image.width - 4, 2, CreateColor(128, 128, 128, 255));
  this.image.line(2, 2, 2, this.image.height - 4, CreateColor(128, 128, 128, 255));

  this.image.line(2, this.image.height - 3, this.image.width - 3, this.image.height - 3, CreateColor(255, 255, 255, 255));
  this.image.line(this.image.width - 3, 2, this.image.width - 3, this.image.height - 3, CreateColor(255, 255, 255, 255));

  this.image.line(3, 3, this.image.width - 5, 3, CreateColor(0, 0, 0, 255));
  this.image.line(3, 3, 3, this.image.height - 5, CreateColor(0, 0, 0, 255));

  this.image.line(3, this.image.height - 4, this.image.width - 4, this.image.height - 4, CreateColor(192, 192, 192, 255));
  this.image.line(this.image.width - 4, 3, this.image.width - 4, this.image.height - 4, CreateColor(192, 192, 192, 255));

  this.image.blitSurface(scrollDown, this.image.width - 20, 4);
  this.image.createImage();
  
  this.scrollbar = new _verticalScrollbar(this.x - 16, this.y + 22, this.w, 208, this);  
}

//========================================================================================================================
//                                                     Scroll Down
//========================================================================================================================

_dropBox.prototype.scrollDown = function() 
{
  if (this.yScroll < this.yMax) this.yScroll++;
}

//========================================================================================================================
//                                                     Scroll Up
//========================================================================================================================

_dropBox.prototype.scrollUp = function()
{
  if (this.yScroll > 0) this.yScroll--;
}

//========================================================================================================================
//                                                     Update
//========================================================================================================================

_dropBox.prototype.update = function()
{
  if (mouse.isClicked("left"))
  {
    if (mouse.isMouseOver(this.x + this.image.width - 22, this.y, 16, 16))
    {
      this.yScroll = 0; // This is where we would handle starting the focus
      this.openDrop = !this.openDrop;
      mouse.clearQueue();
    }
    if (this.openDrop && mouse.isMouseOver(this.x - 2, this.y + 20, this.w + 4 - 16, 208))
    { 
      if (Math.floor((GetMouseY() - this.y - 20) / 16) + this.yScroll != this.selection && Math.floor((GetMouseY() - this.y - 20) / 16) + this.yScroll < this.list.length)
      {
        this.selection = Math.floor((GetMouseY() - this.y - 20) / 16) + this.yScroll
        this.parent.updateDropBox(this.selection);
        mouse.clearQueue();
      }
    }
    if (this.openDrop)
    {
      this.scrollbar.update();
    }
  }
}

//========================================================================================================================
//                                                     Render
//========================================================================================================================

_dropBox.prototype.render = function()
{
  this.image.blit(this.x - 2, this.y - 4);
  drawText(this.x + 2, this.y + 4, this.list[this.selection]);
  if (this.openDrop) 
  {
    Rectanngle(0, 0, 200, 200, CreateColor(255, 0, 0, 255));
    this.window.blit(this.x - 2, this.y + 20);
    for (var i = 0; i < 13; i++)
    {
      if (i + this.yScroll >= this.list.length) break;
      if (this.selection - this.yScroll == i) OutlinedRectangle(this.x + 1, this.y + 23 + (i * 16), this.w - 18, 14, black) 
      drawText(this.x + 2, this.y + 26 + (i * 16), this.list[i + this.yScroll]);
    }
    drawText(0, 300, Math.floor((GetMouseY() - this.y - 20) / 16) + this.yScroll);
    if (mouse.isMouseOver(this.x - 2, this.y + 22, this.w + 4 - 16, 208))
    {
      OutlinedRectangle(this.x, this.y + 22 + ((Math.floor((GetMouseY() - this.y - 22) / 16)) * 16), this.w - 16, 16, black);
    }
    this.scrollbar.render();
  }
}



//========================================================================================================================
//
//                                                     Evaluated Scripts
//
//========================================================================================================================

EvaluateScript("Mouse Library.js");
EvaluateScript("Engine.js");
EvaluateScript("Colours.js");
EvaluateScript("JSON.js");

//========================================================================================================================
//
//                                                     Variables
//
//========================================================================================================================





function _frameEngine()
{
  this.CPS = 0;
  this.FPS = 0;
  this.CPSTimer = GetTime();
  this.FPSTimer = GetTime();
  this.currentCPS = 0;
  this.currentFPS = 0;
  this.frame = 0;
  this.time = GetTime();
  
  this.update = function() {};
  this.render = function() {};

  this.execute = function()
  {
    while (!IsKeyPressed(KEY_ESCAPE))
    {
      //this.update();
      this.time = GetTime();
      if (this.time > this.CPSTimer + 1000)
      {
        this.currentCPS = this.CPS + 1;
        this.currentFPS = this.FPS + 1;
        this.CPS = 0;
        this.FPS = 0;
        this.CPSTimer = this.time;
        this.FPSTimer = this.time;
      }
      else
      {  
        this.CPS++;
        if (this.time > this.FPSTimer + (1000 / 60))
        {
          this.FPS++;
          this.FPSTimer += (1000 / 60);
        }
      }
      if (this.frame != this.FPS)
      {
        Rectangle(0, 0, 800, 600, red);
        this.render();
        this.frame = this.FPS;
        drawText(0, 45, this.FPS);
        drawText(0, 15, this.currentCPS);
        drawText(0, 30, this.currentFPS);
        FlipScreen();
      }
    }
  }
}

var tileset = [];
{
  var directories = GetDirectoryList("~/Tiles/"); 
  for (var d = 0; d < directories.length; d++)
  {
    tileset[d] = [];
    tileset[d].name = directories[d];
    tileset[d][0] = -1; // Blank Tile;
    var file = OpenFile("~/Tiles/" + directories[d] + "/" + directories[d] + ".nmf");
    var length = file.read("numTiles", 0);
    var fileList = GetFileList("~/Tiles/" + directories[d]);
    for (var f = 0; f < fileList.length; f++)
    {
      if (fileList[f] == "" + directories[d] + ".nmf") 
      {
        fileList.splice(f, 1);
        break;
      }
    }
    for (var i = 0; i < length; i++)
    {
      var image = file.read("tiles[" + i + "].image", "");
      for (var f = 0; f < fileList.length; f++)
      {
        if (fileList[f] == image)
        {
          var item = new Object;
          tileset[d][tileset[d].length] = { image:LoadSurface("~/Tiles/" + directories[d] + "/" + image), 
          animated:file.read("tiles[" + i + "].animated", false), nextTile:file.read("tiles[" + i + "].nextTile", -1) };
          fileList.splice(f,1);
          break;
        }
      }
    }
    for (var i = 0; i < fileList.length; i++)
    {
      var item = new Object;
      tileset[d][tileset[d].length] = { image:LoadSurface("~/Tiles/" + directories[d] + "/" + fileList[i]),
      animated:false, nextTile:-1 };
      file.write("tiles[" + tileset[d].length + "].image", fileList[i]);
      file.write("tiles[" + (tileset[d].length - 1) + "].animated", false);
      file.write("tiles[" + (tileset[d].length - 1) + "].nextTile", -1);
      fileList.splice(i, 1);
      i--;
    }
    file.write("numTiles", tileset[d].length);
    file.flush();
    file.close();
  }
}

var objectset = [];
{ 
  var directories = GetDirectoryList("~/Objects/");
  for (var d = 0; d < directories.length; d++)
  {
    objectset[d] = [];
    objectset[d][0] = -1;
    var file = OpenFile("~/Objects/" + directories[d] + "/" + directories[d] + ".nmf");
    var fileList = GetFileList("~/Objects/" + directories[d]);
    var length = file.read("numTiles", 0);

    for (var f = 0; f < fileList.length; f++)
    {
      for (var i = 0; i < length; i++)
      {
        if (file.read("tiles[" + i + "].image", "") == fileList[f])
        {
          objectset[d][objectset[d].length] = new objectParent(fileList[f], "~/Objects/" + directories[d] + "/");
          fileList.splice(f, f);
          f--;
        }
      }
    }
    for (var f = 0; f < fileList.length; f++)
    {
      if (fileList[f].slice(fileList[f].length - 4, fileList[f].length) == ".png")
      {
        objectset[d][objectset[d].length] = new objectParent(fileList[f], "~/Objects/" + directories[d] + "/");
        fileList.splice(f, f);
        f--;
      }
    }   
  }
}

var width = 10;
var height = 10;
var numLayers = 1;
  
var layer = [];
{
  for (var l = 0; l < numLayers; l++)
  {
    layer[l] = [];
    for (var i = 1; i < 3; i++)
    {
      layer[l][i-1] = { tiles:[], image:CreateSurface(32 * (width + i), 32 * (height + i), CreateColor(0, 0, 0, 0)) };
      layer[l][i-1].image.setBlendMode(REPLACE);
      for (var y = 0; y < height * i; y++)
      {
        layer[l][i-1].tiles[y] = [];
        for (var x = 0; x < width * i; x++)
        {      
          if (i == 1)
          {
            layer[l][i-1].tiles[y][x] = { index:0, tileset:0 };
            layer[l][i-1].image.blitSurface(tileset[0][1].image, x * (32 / i), y * (32/i))
          }
          else layer[l][i-1].tiles[y][x] = undefined;
        }
      }
    }
  }
}

var mouse = new _mouse();
var frameEngine = new _frameEngine();
var tilesetPanel2 = new _tilesetPanel2();
var objectsPanel2 = new _objectsPanel2();
var mapPanel2 = new _mapPanel2();

var current = { tilesetIndex:0, tileset:tileset[0], tile:0 }
var currentLayer = 0;
var internalLayer = 0;

function game()
{
  frameEngine.render = function() 
  { 
    tilesetPanel2.update(); 
    objectsPanel2.update();
    mapPanel2.update()
    mouse.update(); 
    tilesetPanel2.render(); 
    objectsPanel2.render();
    mapPanel2.render(); 
    mouse.draw(); 
  };
  frameEngine.execute();
}

function _tilesetPanel2()
{
  this.x = 2 + 150;
  this.y = 100;
  this.w = 192;
  this.h = 192;
  this.window = createWindow(this.w, this.h, 16, 16);
  
  this.tileW = 32;
  this.tileH = 32;
  
  this.hMax = Math.floor(this.w / this.tileW);
  this.vMax = Math.floor(this.h / this.tileH);
  this.yScroll = 0;
  this.yMax = Math.ceil(((tileset[0].length + 1) / this.hMax) - this.vMax);
  this.xScroll = 0;
  this.xMax = tileset.length - 1;
  if (this.yMax < 0) this.yMax = 0;
  
  this.scrollbarH = new _horizontalScrollbar(this.x, this.y, this.w, this.h, this);
  this.scrollbarV = new _verticalScrollbar(this.x, this.y, this.w, this.h, this);
  this.dropBox = new _dropBox(this.x, this.y - 22, this.w + 16, this, GetDirectoryList("~/Tiles/"));
}

_tilesetPanel2.prototype.scrollDown = function() 
{
  if (this.yScroll < this.yMax) this.yScroll++;
}

_tilesetPanel2.prototype.scrollUp = function()
{
  if (this.yScroll > 0) this.yScroll--;
}

_tilesetPanel2.prototype.scrollRight = function() 
{
  if (this.xScroll < this.xMax) 
  {
    this.xScroll++;
    this.yMax = Math.ceil(((tileset[this.xScroll].length + 1) / this.hMax) - this.vMax);
    if (this.yMax < 0) this.yMax = 0;
    this.yScroll = 0;
    this.scrollbarV.create();
  }
}

_tilesetPanel2.prototype.scrollLeft = function()
{
  if (this.xScroll > 0) 
  {
    this.xScroll--;
    this.yMax = Math.ceil(((tileset[this.xScroll].length + 1) / this.hMax) - this.vMax);
    if (this.yMax < 0) this.yMax = 0;
    this.yScroll = 0;
    this.scrollbarV.create();
  }
}

_tilesetPanel2.prototype.updateDropBox = function(number)
{
  this.xScroll = number;
  this.yMax = Math.ceil(((tileset[this.xScroll].length + 1) / this.hMax) - this.vMax);
  if (this.yMax < 0) this.yMax = 0;
  this.yScroll = 0;
  this.scrollbarV.create();
}

_tilesetPanel2.prototype.update = function()
{
  if (mouse.isClicked("left"))
  {
    if (mouse.isMouseOver(this.x, this.y, this.w, this.h))
    {
      var point = getTile(GetMouseX() - this.x, GetMouseY() - this.y, 32, 32);
      current = { tileset: tileset[this.xScroll], tilesetIndex:this.xScroll, tile: point.x + ((point.y + this.yScroll) * this.hMax) }
      internalLayer = 0;
    }
    this.dropBox.update();
    this.scrollbarH.update();
    this.scrollbarV.update();
  }
}

_tilesetPanel2.prototype.render = function()
{
  this.window.blit(this.x-2, this.y-2);
  var tempX = 0;
  var tempY = 0;
  for (var i = this.yScroll * this.hMax; i < tileset[this.xScroll].length; i++)
  {
    if (i > 0) tileset[this.xScroll][i].image.blit(this.x+(tempX*32), this.y+(tempY*32));
    if (internalLayer == 0 && this.xScroll == current.tilesetIndex && i == current.tile) drawTileSelect(this.x+(tempX*32), this.y+(tempY*32), 32, 32, red); // TEMPORARY
    tempX++;
    if (tempX >= this.hMax) 
    {
      tempX = 0; 
      tempY++;
    }
    if (tempY >= this.vMax) break;
  }
  this.scrollbarH.render();
  this.scrollbarV.render();
  this.dropBox.render();
}










//=================================================================================================================================

function objectParent(image, location)
{
  var file = OpenFile(location + (image.slice(0, image.length-4) + ".nof"));
  this.image = LoadSurface(location + image);
  this.width = file.read("width", 0);
  this.height = file.read("height", 0);
  file.close();
}

function objectChild(parent)
{
  this.parent = parent;
}


//=================================================================================================================================




















function _objectsPanel2()
{
  this.x = 2 + 150;
  this.y = 336;
  this.w = 192;
  this.h = 192;
  this.window = createWindow(this.w, this.h, 16, 16);
  
  this.tileW = 64;
  this.tileH = 64;
  
  this.hMax = Math.floor(this.w / this.tileW);
  this.vMax = Math.floor(this.h / this.tileH);
  this.yScroll = 0;
  this.yMax = Math.ceil(((objectset[0].length + 1) / this.hMax) - this.vMax);
  if (this.yMax < 0) this.yMax = 0;
  this.xScroll = 0;
  this.xMax = objectset.length - 1;
  
  this.scrollbarH = new _horizontalScrollbar(this.x, this.y, this.w, this.h, this);
  this.scrollbarV = new _verticalScrollbar(this.x, this.y, this.w, this.h, this);
  this.dropBox = new _dropBox(this.x, this.y - 22, this.w + 16, this, GetDirectoryList("~/Objects/"));
}

_objectsPanel2.prototype.scrollDown = function() 
{
  if (this.yScroll < this.yMax) this.yScroll++;
}

_objectsPanel2.prototype.scrollUp = function()
{
  if (this.yScroll > 0) this.yScroll--;
}

_objectsPanel2.prototype.scrollRight = function() 
{
  if (this.xScroll < this.xMax) 
  {
    this.xScroll++;
    this.yMax = Math.ceil(((objectset[this.xScroll].length + 1) / this.hMax) - this.vMax);
    if (this.yMax < 0) this.yMax = 0;
    this.yScroll = 0;
    this.scrollbarV.create();
  }
}

_objectsPanel2.prototype.scrollLeft = function()
{
  if (this.xScroll > 0) 
  {
    this.xScroll--;
    this.yMax = Math.ceil(((objectset[this.xScroll].length + 1) / this.hMax) - this.vMax);
    if (this.yMax < 0) this.yMax = 0;
    this.yScroll = 0;
    this.scrollbarV.create();
  }
}

_objectsPanel2.prototype.updateDropBox = function(number)
{
  this.xScroll = number;
  this.yMax = Math.ceil(((objectset[this.xScroll].length + 1) / this.hMax) - this.vMax);
  if (this.yMax < 0) this.yMax = 0;
  this.yScroll = 0;
  this.scrollbarV.create();
}

_objectsPanel2.prototype.update = function()
{
  if (mouse.isClicked("left"))
  {
    if (mouse.isMouseOver(this.x, this.y, this.w, this.h))
    {
      var point = getTile(GetMouseX() - this.x, GetMouseY() - this.y, 64, 64);
      
      current = { tilesetIndex:this.xScroll, tileset:objectset[this.xScroll], tile:point.x + ((point.y + this.yScroll) * this.hMax) };      
      internalLayer = 1;
    }
    this.dropBox.update();
    this.scrollbarH.update();
    this.scrollbarV.update();
  }
}

_objectsPanel2.prototype.render = function()
{
  this.window.blit(this.x-2, this.y-2);
  var tempX = 0;
  var tempY = 0;
  for (var i = this.yScroll * this.hMax; i < objectset[this.xScroll].length; i++)
  {
    if (i > 0) objectset[this.xScroll][i].image.blit(this.x+(tempX*this.tileW), this.y+(tempY*this.tileH));
    if (internalLayer == 1 && this.xScroll == current.tilesetIndex && i == current.tile) drawTileSelect(this.x+(tempX*this.tileW), this.y+(tempY*this.tileH), this.tileW, this.tileH, red); // TEMPORARY
    tempX++;
    if (tempX == this.vMax) 
    {
      tempX = 0; 
      tempY++;
    }
    if (tempY == this.vMax) break;
  }
  this.scrollbarH.render();
  this.scrollbarV.render();
  this.dropBox.render();
}







function _mapPanel2()
{
  this.x = 214 + 150;
  this.y = 100;
  this.w = 320;
  this.h = 320;
  this.window = createWindow(this.w, this.h, 16, 16);
  
  this.tile = { x:0, y:0, realX:0, realY:0 }
  
  this.tileW = 32;
  this.tileH = 32;
  
  this.hMax = Math.floor(this.w / this.tileW);
  this.vMax = Math.floor(this.h / this.tileH);
  this.yScroll = 0;
  this.yMax = Math.ceil(this.h / 32) - this.vMax + 1;
  if (this.yMax < 0) this.yMax = 0;
  this.xScroll = 0;
  this.xMax = Math.ceil(this.w / 32) - this.hMax + 1;
  if (this.hMax < 0) this.hMax = 0;
  
  this.scrollbarH = new _horizontalScrollbar(this.x, this.y, this.w, this.h, this);
  this.scrollbarV = new _verticalScrollbar(this.x, this.y, this.w, this.h, this);
}

_mapPanel2.prototype.save = function()
{
  //RemoveFile("~/Maps2/Map 0.nmf");
  //var file = OpenFile("~/Maps2/Map 0.nmf");
  //file.write("height", height);
  //file.write("width", width);
//
  //file.write("layer", JSON.stringify(layer));
  //file.flush();
  //file.close();
}

_mapPanel2.prototype.scrollDown = function() 
{
  if (this.yScroll < this.yMax) this.yScroll++;
}

_mapPanel2.prototype.scrollUp = function()
{
  if (this.yScroll > 0) this.yScroll--;
}

_mapPanel2.prototype.scrollRight = function() 
{
  if (this.xScroll < this.xMax) this.xScroll++;
}

_mapPanel2.prototype.scrollLeft = function()
{
  if (this.xScroll > 0) this.xScroll--;
}

_mapPanel2.prototype.update = function()
{
  if (mouse.isClicked("left"))
  {
    if (mouse.isMouseOver(this.x, this.y, this.w, this.h))
    {   
      this.tile.x = Math.floor((GetMouseX() - this.x) / (32 / (internalLayer + 1)));
      this.tile.y = Math.floor((GetMouseY() - this.y) / (32 / (internalLayer + 1)));
      this.tile.realX = this.tile.x - numLayers - internalLayer + (this.xScroll * (internalLayer + 1));
      this.tile.realY = this.tile.y - numLayers - internalLayer + (this.yScroll * (internalLayer + 1));
      if (this.tile.realX > -1 && this.tile.realY > -1) this.updateLayer(this.tile.realX, this.tile.realY);
    }
    this.scrollbarH.update();
    this.scrollbarV.update();
  }
}

_mapPanel2.prototype.drawObject = function(x, y)
{
  var tempLayer = layer[currentLayer][internalLayer];
  var temp = CreateSurface(64, 64, CreateColor(0, 0, 0, 0)); // Surface the size of the object
  
  for (var yy = -2; yy < 4; yy++)
  {
    for (var xx = -2; xx < 4; xx++)
    {
      if (tempLayer.tiles[y+yy] && !tempLayer.tiles[y+yy][x+xx]) continue // If blank tile skip
      if (tempLayer.tiles[y+yy] && tempLayer.tiles[y+yy][x+xx] instanceof objectParent)
      {
        temp.blitSurface(tempLayer.tiles[y+yy][x+xx].image, xx * 16, yy * 16);
        // If parent then draw and add its width to the xx
        continue
      }
      if (tempLayer.tiles[y+yy] && tempLayer.tiles[y+yy][x+xx] instanceof objectChild)
      {
        if (tempLayer.tiles[y+yy][x+xx-tempLayer.tiles[y+yy][x+xx].parent.width] == tempLayer.tiles[y+yy][x+xx].parent && xx-tempLayer.tiles[y+yy][x+xx].parent.width < -2)
        {
          // If the tile to the left (by the parents width) is the parent and its out of scope
          temp.blitSurface(tempLayer.tiles[y+yy][x+xx].parent.image, (xx-tempLayer.tiles[y+yy][x+xx-tempLayer.tiles[y+yy][x+xx].parent.width].width) * 16, yy * 16);
          // Draw the parent to the correct offset
          continue
        }
      }
    }
  }
  return temp;
}

_mapPanel2.prototype.updateLayer = function(x, y)
{   
  switch (internalLayer)
  {
    case 0:
    {
      layer[currentLayer][internalLayer].tiles[y][x].index = current.tile;
      layer[currentLayer][internalLayer].tiles[y][x].tileset = current.tilsetIndex;
      layer[currentLayer][internalLayer].image.blitSurface(current.tileset[current.tile].image, x * 32, y * 32);
      return;
    }
    case 1:
    {
      if (!layer[currentLayer][internalLayer].tiles[y][x])
      {
        for (var xx = 0; xx < current.tileset[current.tile].width + 1; xx++)
        {
          for (var yy = 0; yy < current.tileset[current.tile].height + 1; yy++)
          {
            if (xx + yy != 0)
            {
              if (layer[currentLayer][internalLayer].tiles[y+yy][x+xx]) return;
              layer[currentLayer][internalLayer].tiles[y+yy][x+xx] = new objectChild(current.tileset[current.tile]);
            }
          }
        }
        layer[currentLayer][internalLayer].tiles[y][x] = current.tileset[current.tile];
        var temp = this.drawObject(x, y);
        layer[currentLayer][internalLayer].image.blitSurface(temp, (x * 16), (y * 16));
        return
      }
    }
  }
}

_mapPanel2.prototype.render = function()
{
  this.window.blit(this.x - 2, this.y - 2);
  this.scrollbarH.render();
  this.scrollbarV.render();
  SetClippingRectangle(this.x, this.y, this.w, this.h)
  for (var l = 0; l < numLayers; l++)
  {
    for (var i = 0; i < layer[l].length; i++)
    {
      layer[l][i].image.blit(this.x + (numLayers * 32) - (i * 32) - (this.xScroll * 32), this.y + (numLayers * 32) - (i * 32) - (this.yScroll * 32));
    }
  }
  SetClippingRectangle(0, 0, 800, 600);
  if (mouse.isMouseOver(this.x, this.y, this.w, this.h) && this.tile.realY > -1 && this.tile.realX > -1)
  {
    if (internalLayer == 0) drawTileSelect(this.x + (this.tile.x * 32), this.y + (this.tile.y * 32), 32, 32, red);
    else if (current.tile) current.tileset[current.tile].image.createImage().blitMask(this.x + (this.tile.x * 16) - 32, this.y + (this.tile.y * 16) - 32, CreateColor(255, 0, 0, 120))
  }
  
  drawText(0, 100, "Current Layer: " + currentLayer);
  drawText(0, 115, "Internal Layer: " + internalLayer);
  drawText(0, 130, "Tileset: " + current.tilesetIndex);
  drawText(0, 145, "Tile: " + current.tile);
}